#ifndef CRFEPURHIDDENSETTINGS_H
#define CRFEPURHIDDENSETTINGS_H

#include "../../ui/TabWidget.h"
#include "../../ui/ConfigDialog.h"
#include <ui_CRfePurHiddenSettings.h>

class QrfeRfePurReader;

class CRfePurHiddenSettings : public ReaderTabWidget, ConfigDialog
{
    Q_OBJECT

public:
    CRfePurHiddenSettings(QTextEdit* infoEdit, QWidget* parent);
    ~CRfePurHiddenSettings();

	virtual bool init(QrfeReaderInterface* reader);
	virtual void deinit();
	virtual void activated();

private slots:
	void reloadSettings();

	void setMinAtt();
	void setFrequOffset();
	void setDefaultFrequList();
    void setDefaultModSet();
    void setAntennaCount();
    void setPowerSafeSettings();
    void setReferenceFrequency();

	void setMinAttLabel(int val);

private:
    int refFrequencyToIndex(uchar refFreq);
    uchar indexToRefefreqeuncy(int index);

private:
    QrfeRfePurReader* 		m_reader;

    Ui::CRfePurHiddenSettingsClass ui;
};

#endif // CRFEPURREADERSETTINGS_H
